/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.container;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.slot.FakeSlot;
import appeng.util.ConfigMenuInventory;
import com.github.glodblock.extendedae.common.parts.PartThresholdLevelEmitter;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class ContainerThresholdLevelEmitter
extends UpgradeableMenu<PartThresholdLevelEmitter> {
    private static final String ACTION_SET_UPPER_VALUE = "setUpperValue";
    private static final String ACTION_SET_LOWER_VALUE = "setLowerValue";
    public static final class_3917<ContainerThresholdLevelEmitter> TYPE = MenuTypeBuilder.create(ContainerThresholdLevelEmitter::new, PartThresholdLevelEmitter.class).withInitialData((host, buffer) -> {
        GenericStack.writeBuffer((GenericStack)host.getConfig().getStack(0), (class_2540)buffer);
        buffer.method_10791(host.getUpperValue());
        buffer.method_10791(host.getLowerValue());
    }, (host, menu, buffer) -> {
        ((PartThresholdLevelEmitter)menu.getHost()).getConfig().setStack(0, GenericStack.readBuffer((class_2540)buffer));
        menu.upperValue = buffer.method_10792();
        menu.lowerValue = buffer.method_10792();
    }).build("threshold_level_emitter");
    @GuiSync(value=7)
    public long upperValue;
    @GuiSync(value=8)
    public long lowerValue;

    public ContainerThresholdLevelEmitter(int id, class_1661 ip, PartThresholdLevelEmitter host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.registerClientAction(ACTION_SET_UPPER_VALUE, Long.class, this::setUpperValue);
        this.registerClientAction(ACTION_SET_LOWER_VALUE, Long.class, this::setLowerValue);
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        if (cm.hasSetting(Settings.FUZZY_MODE)) {
            this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
        }
        this.setRedStoneMode((RedstoneMode)cm.getSetting(Settings.REDSTONE_EMITTER));
    }

    public boolean supportsFuzzySearch() {
        return ((PartThresholdLevelEmitter)this.getHost()).getConfigManager().hasSetting(Settings.FUZZY_MODE) && this.hasUpgrade((class_1935)AEItems.FUZZY_CARD);
    }

    @Nullable
    public AEKey getConfiguredFilter() {
        return ((PartThresholdLevelEmitter)this.getHost()).getConfig().getKey(0);
    }

    protected void setupConfig() {
        ConfigMenuInventory inv = ((PartThresholdLevelEmitter)this.getHost()).getConfig().createMenuWrapper();
        this.addSlot((class_1735)new FakeSlot((InternalInventory)inv, 0), SlotSemantics.CONFIG);
    }

    public void setUpperValue(long value) {
        if (this.isClientSide()) {
            if (value != this.upperValue) {
                this.upperValue = value;
                this.sendClientAction(ACTION_SET_UPPER_VALUE, value);
            }
        } else {
            ((PartThresholdLevelEmitter)this.getHost()).setUpperValue(value);
        }
    }

    public void setLowerValue(long value) {
        if (this.isClientSide()) {
            if (value != this.lowerValue) {
                this.lowerValue = value;
                this.sendClientAction(ACTION_SET_LOWER_VALUE, value);
            }
        } else {
            ((PartThresholdLevelEmitter)this.getHost()).setLowerValue(value);
        }
    }
}

